<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Attachment extends Model 
{

    protected $table = 'attachments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('attachment_type_id', 'path');

    public function form()
    {
        return $this->belongsTo('Notes');
    }

    public function type()
    {
        return $this->belongsTo('AttachmentType');
    }

}